;***************************************************************************
;* 
;* File Name:           ATtiny13.INC
;* Title:               Register/Bit Definitions for the AT Tiny13 Device
;*  (adopted from AT94k version)
;*
;* DESCRIPTION
;* When including this file in the assembly program file, all I/O register      
;* names and I/O register bit names appearing in the data book can be used.
;* In addition, the six registers forming the three data pointers X, Y and
;* Z have been assigned names XL - ZH.
;*
;* The Register names are represented by their hexadecimal address.
;* 
;* The Register Bit names are represented by their bit number (0-7).
;* 
;* Please observe the difference in using the bit names with instructions
;* such as "sbr"/"cbr" (set/clear bit in register) and "sbrs"/"sbrc" 
;* (skip if bit in register set/cleared). The following example illustrates
;* this:
;* 
;* in   r16,PORTB               ;read PORTB latch
;* sbr  r16,(1<<PB6)+(1<<PB5)   ;set PB6 and PB5 (use masks, not bit#)
;* out  PORTB,r16               ;output to PORTB
;*
;* in   r16,TIFR                ;read the Timer Interrupt Flag Register
;* sbrc r16,TOV0                ;test the overflow flag (use bit#)
;* rjmp TOV0_is_set             ;jump if set
;* ...                          ;otherwise do something else
;***************************************************************************



;***** Specify Device *****

.device ATtiny13 




;***** I/O Register Definitions *****

.equ    SREG            = $3F

.equ    SPL             = $3D

.equ    GIMSK           = $3B
.equ    GIFR            = $3A
.equ    TIMSK0          = $39
.equ    TIFR0           = $38
.equ    SPMCSR          = $37
.equ    OCR0A           = $36
.equ    MCUCR           = $35
.equ    MCUSR           = $34
.equ    TCCR0B          = $33
.equ    TCNT0           = $32
.equ    OSCCAL          = $31

.equ    TCCR0A          = $2F
.equ    DWDR            = $2E

.equ    OCR0B           = $29
.equ    GTCCR           = $28

.equ    CLKPR           = $26
        
.equ    WDTCR           = $21

.equ    EEARL           = $1E
.equ    EEDR            = $1D
.equ    EECR            = $1C

.equ    PORTB           = $18
.equ    DDRB            = $17
.equ    PINB            = $16
.equ    PCMSK           = $15
.equ    DIDR0           = $14

.equ    ACSR            = $08
.equ    ADMUX           = $07
.equ    ADCSRA          = $06
.equ    ADCH            = $05
.equ    ADCL            = $04
.equ    ADCSRB          = $03
 

;***** Bit Definitions *****

;* GIMSK Register *
.equ    INT0		= 6
.equ    PCIE		= 5

;* GIFR Register *
.equ    INTF0		= 6
.equ    PCIF		= 5


;* TIMSK0 Register *
.equ    OCIE0B		= 3
.equ    OCIE0A		= 2
.equ    TOIE0		= 1

;* TIFR0 Register *
.equ    OCF0B		= 3
.equ    OCF0A		= 2
.equ    TOV0		= 1

;* SPMCSR Register *
.equ	CTPB		= 4
.equ	RFLB		= 3 
.equ	PGWRT		= 2
.equ	PGERS		= 1
.equ	SELFPRGEN	= 0

;* MCUCR Register *
.equ	PUD			= 6
.equ	SE			= 5
.equ	SM1 		= 4
.equ	SM0			= 3 
.equ	ISC01		= 1
.equ	ISC00		= 0


;* MCUSR Register *
.equ	WDRF		= 3 
.equ	BORF		= 2
.equ	EXTRF		= 1
.equ	PORF		= 0



;* TCCR0B Register *
.equ	FOC0A		= 7
.equ	FOC0B		= 6
.equ	WGM02		= 3 
.equ	CS02		= 2 
.equ	CS01		= 1
.equ	CS00		= 0

;* TCCR0A Register *
.equ	COM0A1		= 7
.equ	COM0A0		= 6
.equ	COM0B1		= 5 
.equ	COM0B0		= 4 
.equ	WGMO1		= 1
.equ	WGMO0		= 0


;* GTCCR Register *
.equ	TSM			= 7
.equ	PSR10		= 0


;* CLKPR Register *
.equ	CLKPCE		= 7
.equ	CLKPS3		= 3 
.equ	CLKPS2		= 2 
.equ	CLKPS1		= 1
.equ	CLKPS0		= 0


;* WDTCR Register *
.equ	WDTIF		= 7
.equ	WDTIE		= 6
.equ	WDP3		= 5 
.equ	WDCE		= 4
.equ	WDE			= 3 
.equ	WDP2		= 2 
.equ	WDP1		= 1
.equ	WDP0		= 0


;* EECR Register *
.equ	EEPM1		= 5 
.equ	EEPM0		= 4
.equ	EERIE		= 3 
.equ	EEMWE		= 2 
.equ	EEWE		= 1
.equ	EERE		= 0


;* PORTB Register *
.equ	PORTB5		= 5 
.equ	PORTB4		= 4
.equ	PORTB3		= 3 
.equ	PORTB2		= 2 
.equ	PORTB1		= 1
.equ	PORTB0		= 0


;* DDRB Register *
.equ	DDB5		= 5 
.equ	DDB4		= 4
.equ	DDB3		= 3 
.equ	DDB2		= 2 
.equ	DDB1		= 1
.equ	DDB0		= 0

;* PINB Register *
.equ	PINB5		= 5 
.equ	PINB4		= 4
.equ	PINB3		= 3 
.equ	PINB2		= 2 
.equ	PINB1		= 1
.equ	PINB0		= 0

;* PCMSK Register *
.equ	PCINT5		= 5 
.equ	PCINT4		= 4
.equ	PCINT3		= 3 
.equ	PCINT2		= 2 
.equ	PCINT1		= 1
.equ	PCINT0		= 0

;* DIDR0 Register *
.equ	ADC0D		= 5 
.equ	ADC2D		= 4
.equ	ADC3D		= 3 
.equ	ADC1D		= 2 
.equ	EIN1D		= 1
.equ	AIN0D		= 0

;* ACSR Register *
.equ	ACD			= 7
.equ	ACBG		= 6
.equ	ACO			= 5 
.equ	ACI			= 4
.equ	ACIE		= 3 
.equ	ACIS1		= 1
.equ	ACIS0		= 0

;* ADMUX Register *
.equ	REFS0		= 6
.equ	ADLAR		= 5 
.equ	MUX1		= 1
.equ	MUX0		= 0

;* ADCSRA Register *
.equ	ADEN		= 7
.equ	ADSC		= 6
.equ	ADATE		= 5 
.equ	ADIF		= 4
.equ	ADIE		= 3 
.equ	ADPS2		= 2 
.equ	ADPS1		= 1
.equ	ADPS0		= 0

;* ADCSRB Register *
.equ	ACME		= 6
.equ	ADTS2		= 2 
.equ	ADTS1		= 1
.equ	ADTS0		= 0



;***** Registers Forming Data Pointers *****

.def    XL              = r26
.def    XH              = r27
.def    YL              = r28
.def    YH              = r29
.def    ZL              = r30
.def    ZH              = r31



;***** Interrupt Vector Addresses *****

.equ    RESETaddr       = $0000         ;Reset - Program Execution Starts Here
.equ    INT0addr    	= $0001         ;External Interrupt Request 0
.equ    PCINT0addr	   	= $0002         ;Pin Change Interrupt Request 0
.equ    TIM0_OVFaddr    = $0003         ;Timer/Counter Overflow Interrupt
.equ    EE_RDYaddr		= $0004         ;EEPROM Ready Interrupt 
.equ    ANA_COMPaddr	= $0005         ;Analog Comparator
.equ    TIM0_COMPAaddr	= $0006         ;Timer/Counter Compare Match A Interrupt
.equ    TIM0_COMPBaddr	= $0007         ;Timer/Counter Compare Match B Interrupt
.equ    WDTaddr			= $0008         ;Watchdog Time-out Interrupt
.equ    ADCaddr			= $0009         ;ADC Conversion Complete Interrupt


